#ifndef SPACESHIP_H
#define SPACESHIP_H

#include <dactuator.h>
#include <dgun.h>
#include <atomdir.h>
#include <multiatomdir.h>
#include <particle.h>
#include <material.h>
#include "grapplinghook.h"

struct Spaceship : public Material {
	DActuator *left_engine;
	DActuator *right_engine;
	DGun *main_cannon;
	GrapplingHook *grappling_hook;

	AtomDir *left_engine_dir;
	AtomDir *right_engine_dir;
	MultiAtomDir *main_cannon_dir;

	bool *accelerate;
	bool *decelerate;
	bool *turn_left;
	bool *turn_right;
	float engine_power;
	Texture *particle;

	Spaceship(Object *parent, bool *fire_cannon, bool *fire_grappling_hook, bool *accelerate, bool *decelerate, bool *turn_left, bool *turn_right, float engine_power = 1.0f);
	void stepFunc();
	void calculateCenter();
	void addAtom(Atom *a);
};

#endif